/*:ja
 * @target MZ
 * @plugindesc メッセージウィンドウの位置を調整します。
 * @author ガバチョ（溟犬一六）
 * @url https://star-write-dream.com/
 *
 * @help GABA_MessageWindowPosition.js(ver1.0.0)
 *
 * マップでのメッセージウィンドウの位置を調整します。
 * ※戦闘時のメッセージウィンドウには効果ありません。
 *
 * プラグインコマンドはありません。
 * 
 * プラグインパラメーターで位置を調整してください。
 * 
 * --------------------------
 * Copyright (c) 2021 Gabacho(Ichiro Meiken)
 * Released under the MIT license
 * https://opensource.org/licenses/mit-license.php
 * --------------------------
 * 
 * @param upX
 * @text 上ウィンドウ調整X
 * @type number
 * @desc メッセージウィンドウの横位置を調整する値をピクセル数で指定。ウィンドウ位置が「上」の時に影響します。（初期値：0）
 * @default 0
 * @min -999
 * 
 * @param upY
 * @text 上ウィンドウ調整Y
 * @type number
 * @desc メッセージウィンドウの縦位置を調整する値をピクセル数で指定。ウィンドウ位置が「上」の時に影響します。（初期値：0）
 * @default 0
 * @min -999
 *
 * @param midX
 * @text 中ウィンドウ調整X
 * @type number
 * @desc メッセージウィンドウの横位置を調整する値をピクセル数で指定。ウィンドウ位置が「中」の時に影響します。（初期値：0）
 * @default 0
 * @min -999
 *
 * @param midY
 * @text 中ウィンドウ調整Y
 * @type number
 * @desc メッセージウィンドウの縦位置を調整する値をピクセル数で指定。ウィンドウ位置が「中」の時に影響します。（初期値：0）
 * @default 0
 * @min -999
 *
 * @param downX
 * @text 下ウィンドウ調整X
 * @type number
 * @desc メッセージウィンドウの横位置を調整する値をピクセル数で指定。ウィンドウ位置が「下」の時に影響します。（初期値：0）
 * @default 0
 * @min -999
 *
 * @param downY
 * @text 下ウィンドウ調整Y
 * @type number
 * @desc メッセージウィンドウの縦位置を調整する値をピクセル数で指定。ウィンドウ位置が「下」の時に影響します。（初期値：0）
 * @default 0
 * @min -999
 *
 */